export type Tuple<
  T,
  N extends number,
  R extends readonly T[] = [],
> = R['length'] extends N ? R : Tuple<T, N, readonly [T, ...R]>

export type Radii = Tuple<number,4>


type ObjectXY = {
  /**
   * x
   */
  a : number;
  /**
   * y
   */
  b : number;
}

type ObjectRadii = {
  /**
   * border-radius top left
   */
  e : number;
  /**
   * border-radius top right
   */
  f : number;
  /**
   * border-radius bottom right
   */
  g : number;
  /**
   * border-radius bottom left
   */
  h : number;
}

type ObjectSize = {

  /**
   * width
   */
  c : number;
  /**
   * height
   */
  d : number;
}

type ObjectId = {
   /**
   * id
   */
   i : number;
}

export type ComponentObject = {
  /**
   * type
   * 0 native component
   * 1 instance / variant
   */
  t : 0;
  /**
   * background color
   */
  k : string;
} & ObjectId & ObjectXY & ObjectRadii & ObjectSize

export type VariantObject = {
  /**
   * type
   * 0 native component
   * 1 instance / variant
   */
  t : 1;
  /**
   * reference to an id
   */
  r : number;
} & ObjectId & ObjectXY

export type SceneJson = {
  /**
   * Background colour
  */
  a: string;
  /**
   * Scene width
   */
  b?: number;
  /**
   * Scene height
   */
  c?: number;
  "objects": Array<ComponentObject | VariantObject>
}
