// removed the loader import FileLoader from './file-loader.js';
import Scene from './scene.ts'
import sceneData from './scene5.json'


document.addEventListener('DOMContentLoaded', () => {
  let ctx
  let canvas = document.getElementById('filePreview');
  let scene

  let isDragging = false
  let isDraggigId = null
  let dragCoords = { x: 0, y: 0 }

  async function loadFile(url) {
    // for convinience, in this exercise I removed the loader
    // const sceneData = await FileLoader.loadScene(url);
    openScene(sceneData);
  }

  function openScene(sceneData) {
    // Setup canvas
    canvas.width = canvas.clientWidth;
    canvas.height = canvas.clientHeight;
    ctx = canvas.getContext('2d');

    // Initiate scene
    scene = new Scene(sceneData);

    // draw scene
    draw()
  }

  canvas.addEventListener('mousedown', (ev) => {
    const { match, pathIndex } = scene.isInShape(ctx, {cx: ev.offsetX, cy: ev.offsetY})
    if (match) {
      isDragging = true
      isDraggigId = pathIndex
      
      // get relative drag coords
      dragCoords = {
        x: scene.shapes[pathIndex].x - ev.offsetX,
        y: scene.shapes[pathIndex].y - ev.offsetY,
      }
    }
  })
  
  canvas.addEventListener('mousemove', (ev) => {
    if (isDragging) {
      scene.shapes[isDraggigId].x = ev.offsetX + dragCoords.x
      scene.shapes[isDraggigId].y = ev.offsetY + dragCoords.y 
    }
  })
  
  document.addEventListener('mouseup', (ev) => {
    isDraggigId = null
    isDragging = false
    dragStart = { x: 0, y: 0 }
  })


  function draw() {
    scene.drawScene(ctx)
    window.requestAnimationFrame(draw)
  }

  loadFile('scene5.json');

  window.loadFile = loadFile;
  window.scene = scene;
})
